#!/usr/bin/perl

#紅月堂本舗謹製
#(C)2008-2009 I.Shinohara
#キャラクターシート管理スクリプト「出納係」
#URL：http://kougetu.sakura.ne.jp/
#mail：http://kougetu.sakura.ne.jp/mail.html

#====================  変数デフォルト値ファイル  ========================#
# CGI中で使用する変数のデフォルト値および、サブルーチンを設定しています。
# 変更した場合、動作の保証は一切しかねます。ご了承ください。
#========================================================================#

#初期処理
sub dataread{
	#cgi_lib上のサイズ取得のbyte数とwindows上のサイズが異なるため差分修正
	#KB→byte変換
	$cgi_lib'maxdata = ($img_maxsize + 11) * 1024;#(byteに変換）

	$post_flag=0;
	$post_flag=1 if ($ENV{'REQUEST_METHOD'} eq "POST");

	&ReadParse(*in);
	@datasets = split(/&/,$in);

	foreach (@datasets) {
		($dataname, $value) = split(/=/);
		$dataname =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
		$value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
	#	&jcode'convert(*value, "sjis", "", "z");	##ver0.9 delete
		Jcode::convert(*value, "utf8", "", "z");	##ver0.9 add

		# 削除データをプール
		if ( $dataname eq "delete" ) { push(@DEL,$value);}
		# HTML出力データをプール
		if ( $dataname eq "html" ) { push(@HTM,$value);}

		$in{$dataname} = $value;
	}
	&var;	#変数宣言

	if ($in{'id'} eq "") { $in{'id'} = 0; }
	if ($in{'page2'} ne ""){ $in{'page'} = $in{'page2'} - 1 ; }
	if ($in{'page'} eq "" || $in{'page'} < 0 ){ $in{'page'} = 0; }
	if ($in{'drcnt'} eq "" || $in{'drcnt'} eq "----"){ $in{'drcnt'} = 0; }
	$cnt = 0;
	$pkey = 1;

}

sub var {#変数　##基本的にユーザー改変を受けない変数

	#リスト表示時の左上メニュー
	$link = "[<a href=\"$home\">HOME</a>]&nbsp;&nbsp;[<a href=\"./$script\">一覧</a>]&nbsp;[<a href=\"./$script?mode=sform\">検索</a>]&nbsp;[<a href=\"$script?mode=pass\">管理</a>]";

	#能力値最大値　##技・体・心値の最大値
	$abmax = '15';

	#備考欄最大文字数
	$bimax = '40';

	#能力値
	@abi = ('器用度','敏捷度','筋　力','生命力','知　力','精神力');

	#防具表示用
	@bougu = ('鎧','盾','その他の修正');
	@bou2 = ('','回避力','防護点');

	#シートタイトル
	$stitle = "キャラクターシート  ";

	#メインの職業表示  ##編集する場合は$lfileもあわせて編集してください。
	$mskill	= "主職業";

	#サブの職業表示  ##編集する場合は$lfileもあわせて編集してください。
	$sskill	= "副職業";

	#画像チェック用　##ここを編集するだけではアップロード可能な形式は増えません。
	@ftype = ('.jpg','.gif','.png');

	#-------------エラーメッセージ-----------#
	@error = (
		'ファイルが開けませんでした。'		#0
		,'不正なアクセスです'			#1
		,'パスワードが一致しません'		#2
		,'名前が入力されていません'		#3
		,'メール送信に失敗しました'		#4
		,'検索項目が入力されていません'		#5
		,'パスワードが入力されていません'	#6
		,'ユーザーによる新規登録は許可されていません'	#7	##ver0.4 update
		,'登録情報が削除されました'		#8	##ver0.6 update
		,'対応していないファイル形式です'	#9	##ver0.7 update
		,'画像のアップロードに失敗しました'	#10	##ver0.7 update
		,'ファイルサイズが大きすぎます'		#11	##ver0.7 update
	);

##ver1.0 add

	#-------------設定ファイルから初期値セット-----------#
	$cnt = 0; $tmp1 =''; $tmp2 =''; $tmp3 ='';	#初期化
	&open7;	#skillファイル呼び出し
	foreach (@log7) {
		local ($tmp1,$tmp2,$tmp3) = split(/##/,$_);
		push(@skill,$tmp1);
		if ($tmp2 ne '') {	##ルーンが存在する場合
			push(@mgc,$tmp2);	##ルーンを配列に挿入
			push(@mgskl,$tmp1);	##使用するスキルを配列に挿入
			push(@mgct,$cnt) if ($tmp3 == '1');	##MP計算を行うスキルを配列に挿入
		}
		$cnt++;
	}


	&open8;	#skillファイル呼び出し
	$cnt =$#log8;
	$tmp ='';
	local ($dust,$dust,$tmp) = split(/##/,$log8[0]);
	$umarej =$tmp;

	for ($d=1;$d<=$cnt;$d++) {
		local ($tmp1,$tmp2,$tmp3) = split(/##/,$log8[$d]);
			push(@syu,$tmp1);	##種族を配列に挿入
			push(@syutok,$tmp2);	##種族特性を配列に挿入
			$umarej = join(",", $umarej, $tmp3);
			$szk = join(",", $szk, $tmp1);
	}
	$cnt = 0;
	@umare =();
	foreach (split(/<>/,$tmp)) {	
		push(@umare,$_);	#生まれを配列に挿入　##生まれは種族が増えた際に増える可能性があるので注意
	}

##ver1.0 add END
}

#データopen
sub open1 {	#個人データ
	open(DB, $cfile) || &error("$error[0]");
	@logc = <DB>;
	close(DB);
}

sub open2 {	#武器データ
	open(DB, $wfile) || &error("$error[0]");
	@logw = <DB>;
	close(DB);
}

sub open3 {	#削除データ
	open(DB, $dfile) || &error("$error[0]");
	@logd = <DB>;
	close(DB);

}

sub open4 {	#メールアドレス
	open(DB, $mfile) || &error("$error[0]");
	@logm = <DB>;
	close(DB);

}

##ver0.5 update
sub open5 {	#フリーコメント
	open(DB, $ffile) || &error("$error[0]");
	@logf = <DB>;
	close(DB);

}
##ver0.5 update END
##ver0.6 update
sub open6 {	#リスト項目
	open(DB, $lfile) || &error("$error[0]");
	@logl = <DB>;
	close(DB);

}
##ver0.6 update END
##ver1.0 add
sub open7 {	#リスト項目
	open(DB, $sfile) || &error("$error[0]");
	@log7 = <DB>;
	close(DB);

}
sub open8 {	#リスト項目
	open(DB, $ufile) || &error("$error[0]");
	@log8 = <DB>;
	close(DB);

}
##ver0.6 add END
#技能変換
sub skchk {
	$skcn = "$skill[$skc]";
	$skcn ='&nbsp;' if($skill[$skc] eq "＿" ) ;
}

#技能変換（リバース）
sub rskill {
	#技能から技能レベルを取得
	$flg = "";
	$scnt = $#skl;
	$scnt = 5 if ($scnt < 5);
	for ($d=0;$d<=$scnt;$d++) {
		if ($sno eq "$in{\"skill$d\"}"){
			$flg = 1;
			last;
		}
	}
	$u_slev = "$in{\"s_lev$d\"}" if ($flg) ;
}

#スキル選択
sub skill {
	$hcnt = $#skill;
	for (0..$hcnt){
		print "\t\t<OPTION value=\"$_\"";
		print " selected" if ($_ eq $sno);
		print ">$skill[$_]</option>\n";
	}
}

#スキル選択
sub dskil {
	for (0..4){
		print "\t\t\t<OPTION value=$_";
		print " selected" if ($_ eq $sno);
		print ">$skill[$_]</option>\n";
	}
}

#ルーン選択
sub rune {
	$hcnt = $#mgc;
	for (0..$hcnt){
		print "\t\t<OPTION value=\"$_\"";
		print " selected" if ($_ eq $rno);
		print ">$mgc[$_]</option>\n";
	}
}

#魔法変換
sub rnchk {
	$rncn = "$mgc[$rnc]" if($rnc ne 0 );
	$rncn ='&nbsp;' if( $mgc[$rnc] eq "＿" ) ;
}

#ルーンから技能レベルを取得
sub rskl {
	$rlv = 0;
	$tmc = $#skl;
	$tmc = 5 if($tmc < 5);
	for (0..$tmc) {
		$tmp = "$in{\"skill$_\"}";
		if( "$mgskl[$rno]" eq "$skill[$tmp]"  ) {
			$rlv = "$in{\"s_lev$_\"}";
			last;
		}
	}
}

sub stok{
	#$tmp =種族情報
	$toksei = '';
	$cnt = $#syu;
	for (0 .. $cnt){
		if ($tmp eq "$syu[$_]") {
			$toksei = "$syutok[$_]";
			last;
		}
	}
}

#状態取得
sub status{
	$hcnt = 0;
	foreach (@sta) {
		if ($_ eq $sta){
			$sno = $hcnt;
		};
		$hcnt++;
	}
	$sta = "$stad[$hcnt]";
}

sub data {#データ変換
	#-----rune----------
	@rn3 = ();
	$tmp = '';
	$cnt = $#runel;
	$cnt = 4 if($cnt < 4);
	for ($d=0; $d<=$cnt; $d++) {	
		#ルーン→使用スキルレベル取得
		$rno = "$in{\"rune$d\"}";
		if ($rno) { #ルーンが設定されている場合のみ
			&rskl;
			$tmp = $rlv + int(($in{'s4'} + $in{'d4'} + $in{'u4'} + $in{'r4'}) / 6 );
		}
		push (@rn3, "$tmp");
		$tmp = "";
	}
	#-----rune END------
	$cnt = "0";
	$in{'gengo'} =~ s/\t\t//g;   #言語変換
	$in{'gengo'} =~ s/\n/<#>/g;   #言語変換
        if ($in{'gengo'} ne "") {	#改行チェック
		foreach  (split(/<#>/,$in{'gengo'})) {
			if ($_){
				if (!$cnt) {
					$gen = "$_";
					$cnt++;
				} else { $gen = join("<#>", "$gen", "$_"); }
			}   
		}
	}
	#-----正規変換------
	#成長値を数値化
	$tmp= '';
	@ux = ();
	for (0..5) {
		$tmp = int($in{"u$_"});
		push (@ux, $tmp)
	}
	
#	$in{'soubi'}=~ s/<BR>//g;
##ver0.6 update
	$in{'ippan'}	=~ s/\n/<>/g;
	$in{'ippan'}	=~ s/<><>//g;
	$in{'tokugi'}	=~ s/\n/<>/g;
	$in{'tokugi'}	=~ s/<><>//g;
	$in{'rengi'}	=~ s/\n/<>/g;
	$in{'rengi'}	=~ s/<><>//g;
	$in{'soubi'}	=~ s/\n/<>/g;
	$in{'soubi'}	=~ s/<><>//g;
	$in{'c_pic'}	=~ s/http:\/\///g;
	$revision = "$in{'r0'}<>$in{'r1'}<>$in{'r2'}<>$in{'r3'}<>$in{'r4'}<>$in{'r5'}<>$in{'hprv'}<>$in{'mprv'}<>$in{'semrv'}<>$in{'sesrv'}<>$in{'morv'}<>$in{'rurv'}";		##ver1.0 update

	$k_point = "$in{'skeip'}<>$in{'mkeip'}";

##ver0.6 update END

	#-----正規変換 END--

	#----技能変換-------
	$cnt = 0;		#数値初期化
	$tmp= '';
	$cnt = $#skl + 2;	#入力行を１行追加
	$cnt = 5 if ($cnt < 5);
	$blev = "$in{'s_lev0'}"; 	#冒険者レベル初期値
	$skdata ="$in{'skill0'}<>$in{'s_lev0'}"; #一行目のみ初期設定
	for ($d = 1;$d < $cnt;$d++) {
		if ($in{"skill$d"} ne 0){
			$tmp = "$in{\"skill$d\"}<>$in{\"s_lev$d\"}";
			$skdata =join("<#>", $skdata, $tmp); 
			$tmp = '';
		}
		#---冒険者レベル取得 ----
		$a = "$in{\"s_lev$d\"}";
		$blev = $a if($a > $blev);
		#---冒険者レベル取得 END--
	}
	#----技能変換 END---
	#----魔法変換-------
	$rndata ="$in{'rune0'}<>$rn3[0]"; #一行目のみ初期設定
	for ($d = 1;$d < $cnt;$d++) {
		if ($in{"skill$d"} ne 0){
			$tmp = "$in{\"rune$d\"}<>$rn3[$d]";
			$rndata =join("<#>", $rndata, $tmp); 
			$tmp = '';
		}
	}
	#----魔法変換 END---
}

#個人シート表示用データ読み込み
sub read1 {
	if ($rid ne "") {
		&open1;
		$d = 0;
		$hashid = 0;
		foreach $line (@logc) {
			$line =~ s/<BR>/\n/g;
			local($lid,$lc_name,$lsex,$lage,$llev,$lsyuzoku,$lstatus,$lskill1,$lskill2,$lbikou,$lpass,$lc_ename,$lc_pic,$lumare,$lbirth,$lsyussin,$lkami,$lhitomi,$lsinchou,$ltaiju,$lsprd,$gsprd,$ls0,$ls1,$ls2,$ld0,$ld1,$ld2,$ld3,$ld4,$ld5,$lu0,$lu1,$lu2,$lu3,$lu4,$lu5,$lskdata,$lrndata,$lippan,$ltokugi,$lrengi,$lpitem,$lk_point,$lmoney,$lrentm,$lsoubi,$lgengo,$lkeireki,$ldate,$lhada,$lrevision) = split(/##/, $line);
			if ($rid == $lid) {
				$id		= $lid;		#ID
				$c_name		= $lc_name;	#名前
				$upass		= $lpass;	#ユーザーパスワード
				$c_ename	= $lc_ename;	#英名
				$sex		= $lsex;	#性別
				$c_pic		= $lc_pic;	#画像
				$age		= $lage;	#年齢
				$lev		= $llev;	#冒険者レベル
				$syuzoku	= $lsyuzoku;	#種族
				$status		= $lstatus;	#状態
				$umare		= $lumare;	#生まれ
				$bikou		= $lbikou;	#備考
				$birth		= $lbirth;	#誕生日
				$syussin	= $lsyussin;	#出身地
				$kami		= $lkami;	#髪の毛
				$hitomi		= $lhitomi;	#瞳の色
				$sinchou	= $lsinchou;	#身長
				$taiju		= $ltaiju;	#体重
				$smp		= $lsprd;	#取得名誉点
				$gmp		= $gsprd;	#合計名誉点
				$ippan		= $lippan;	#一般技能
				$tokugi		= $ltokugi;	#戦闘特技
				$rengi		= $lrengi;	#練技／呪歌
				$pitem		= $lpitem;	#名誉アイテム
				($k1,$k2) = split(/<>/, $lk_point);
				if ($k2 eq '') { 
					$k_point = $lk_point; 
					$k_point =~ s/<>//g;
				} else { $k_point = "$k2／$k1";}
				$money		= $lmoney;	#所持金
				$rentm		= $lrentm;	#借金
				$soubi		= $lsoubi;	#装備品
				$gengo		= $lgengo;	#言語
				$keireki	= $lkeireki;	#経歴
				$date		= $ldate;	#日付
				$hada		= $lhada;	#肌の色

				local($lr0,$lr1,$lr2,$lr3,$lr4,$lr5,$lhprv,$lmprv,$lsemrv,$lsesrv,$lmorv,$lrurv) = split(/<>/,$lrevision);	##ver1.0 update
				$seitei = $smei_b + $lev + $lsemrv;	#生命抵抗
				$sintei = $ssin_b + $lev + $lsesrv;	#精神抵抗
				$hprv		= int($lhprv);	#HP補正
				$mprv		= int($lmprv);	#MP補正
				$semrv		= int($lsemrv);	#生命力抵抗補正
				$sesrv		= int($lsesrv);	#精神力抵抗補正
				$morv		= int($lmorv);	#移動力補正
				$rurv		= int($lrurv);	#魔力補正	##ver1.0 add

				@st = ("$ls0","$ls0","$ls1","$ls1","$ls2","$ls2");	#能力値配列
				@dp = ("$ld0","$ld1","$ld2","$ld3","$ld4","$ld5");	#ダイス目
				@lu = ("$lu0","$lu1","$lu2","$lu3","$lu4","$lu5");	#成長
				@rv = ("$lr0","$lr1","$lr2","$lr3","$lr4","$lr5");	#補正

				#能力値算出
				@abilp = ();
				@abilb = ();
				for (0 .. 5) {
					$abilp[$_] = $st[$_] + $dp [$_] + $lu[$_] + $rv[$_];
					$abilb[$_] = int($abilp[$_] / 6);
				}

				@skl =();
				@runel = ();
				$rcnt = 0;
				foreach (split(/<#>/,$lskdata)) {
					local($a,$b) = split(/<>/);
					$b =~ s/\r|\n//g;
					push(@skl,"$a");	#技能SET
					push(@s_l,"$b");	#技能レベルSET
					$rcnt++;
				}

				foreach (split(/<#>/,$lrndata)) {
					local($a,$b) = split(/<>/);
					$b =~ s/\r|\n//g;
					push(@runel,"$a");	#魔法SET
					push(@r_l,"$b");	#魔力SET
				}
				last;
			} 
			$d++;
		}
		$hashid = $d;
	}

}

##個人シート表示用武器データ読み込み
sub read2 { ## ver0.7 update
	if ($rid ne "") {
		&open2;
		$line = $logw[$hashid];
		($lid,$wep,$dif,$sosk) = split(/##/, $line);
	} 
} ## ver0.7 update END

##メールアドレス呼び出し
sub read3 { ## ver0.7 update
	if ($rid ne "") {
		$line = $logm[$hashid];
		local($mid,$madd,$dust) = split(/##/, $line);
		$mail = $madd;
	} 

} ## ver0.7 update END

##フリーコメント呼び出し　##ver0.5 add
sub read4 { ## ver0.7 update
	if ($rid ne "") {
		&open5;
		$line = $logf[$hashid];
		local($fid,$ffc,$dust) = split(/##/, $line);
		$fc = $ffc;
	} 
} ## ver0.7 update END

##リスト情報呼び出し　##ver0.6 update
sub read5 {
	&open6;
	$cnt = 0;
	foreach $line (@logl) {
		local($lid,$lc_name,$lsex,$lage,$llev,$lsyuzoku,$lstatus,$lskill1,$lskill2,$lbikou,$lpass,$lc_ename,$lc_pic,$lumare,$lbirth,$lsyussin,$lkami,$lhitomi,$lsinchou,$ltaiju,$lsprd,$gsprd,$ls0,$ls1,$ls2,$ld0,$ld1,$ld2,$ld3,$ld4,$ld5,$lu0,$lu1,$lu2,$lu3,$lu4,$lu5,$lskdata,$lrndata,$lippan,$ltokugi,$lrengi,$lpitem,$lk_point,$lmoney,$lrentm,$lsoubi,$lgengo,$lkeireki,$ldate,$lhada,$lrevision) = split(/,/, $line);
		 if($cnt eq 0) { @list3 = ($lid,$lc_name,$lsex,$lage,$llev,$lsyuzoku,$lstatus,$lskill1,$lskill2,$lbikou,$lpass,$lc_ename,$lc_pic,$lumare,$lbirth,$lsyussin,$lkami,$lhitomi,$lsinchou,$ltaiju,$lsprd,$gsprd,$ls0,$ls1,$ls2,$ld0,$ld1,$ld2,$ld3,$ld4,$ld5,$lu0,$lu1,$lu2,$lu3,$lu4,$lu5,$lskdata,$lrndata,$lippan,$ltokugi,$lrengi,$lpitem,$lk_point,$lmoney,$lrentm,$lsoubi,$lgengo,$lkeireki,$ldate,$lhada,$lrevision); }
		 elsif($cnt eq 1) { @list0 = ($lid,$lc_name,$lsex,$lage,$llev,$lsyuzoku,$lstatus,$lskill1,$lskill2,$lbikou,$lpass,$lc_ename,$lc_pic,$lumare,$lbirth,$lsyussin,$lkami,$lhitomi,$lsinchou,$ltaiju,$lsprd,$gsprd,$ls0,$ls1,$ls2,$ld0,$ld1,$ld2,$ld3,$ld4,$ld5,$lu0,$lu1,$lu2,$lu3,$lu4,$lu5,$lskdata,$lrndata,$lippan,$ltokugi,$lrengi,$lpitem,$lk_point,$lmoney,$lrentm,$lsoubi,$lgengo,$lkeireki,$ldate,$lhada,$lrevision); }
		 elsif ($cnt eq 2) { @list1 = ($lid,$lc_name,$lsex,$lage,$llev,$lsyuzoku,$lstatus,$lskill1,$lskill2,$lbikou,$lpass,$lc_ename,$lc_pic,$lumare,$lbirth,$lsyussin,$lkami,$lhitomi,$lsinchou,$ltaiju,$lsprd,$gsprd,$ls0,$ls1,$ls2,$ld0,$ld1,$ld2,$ld3,$ld4,$ld5,$lu0,$lu1,$lu2,$lu3,$lu4,$lu5,$lskdata,$lrndata,$lippan,$ltokugi,$lrengi,$lpitem,$lk_point,$lmoney,$lrentm,$lsoubi,$lgengo,$lkeireki,$ldate,$lhada,$lrevision); }
		 elsif  ($cnt eq 3) { @list2 = ($lid,$lc_name,$lsex,$lage,$llev,$lsyuzoku,$lstatus,$lskill1,$lskill2,$lbikou,$lpass,$lc_ename,$lc_pic,$lumare,$lbirth,$lsyussin,$lkami,$lhitomi,$lsinchou,$ltaiju,$lsprd,$gsprd,$ls0,$ls1,$ls2,$ld0,$ld1,$ld2,$ld3,$ld4,$ld5,$lu0,$lu1,$lu2,$lu3,$lu4,$lu5,$lskdata,$lrndata,$lippan,$ltokugi,$lrengi,$lpitem,$lk_point,$lmoney,$lrentm,$lsoubi,$lgengo,$lkeireki,$ldate,$lhada,$lrevision); last; }
	$cnt++;
	}
}
##ver0.6 update END

#リスト表示
sub list_open { ##ver0.6 update		##サブルーチン全体修正

	&open1;
	@loga = ();
	@loga = sort { $a <=> $b } @logc;
	@logc = ();
	@logc = reverse @loga;
	$skip = 0;
	if ($in{'page'} ne "" && $pkey) {
		$skip = $in{'page'} * $p_max;
		$pkey = 0;
	}
	@log1 = ();
	for ($d = 0;$d < $p_max;$d++) {
		last if($logc[$skip] eq '');
		push(@log1 ,$logc[$skip]);
		$skip++;
	}

	&read5;
	$lcnt =@list0;
	@list3 = ();
	foreach $line (@log1) {
		local($lid,$lc_name,$lsex,$lage,$llev,$lsyuzoku,$lstatus,$lskill1,$lskill2,$lbikou,$lpass,$lc_ename,$lc_pic,$lumare,$lbirth,$lsyussin,$lkami,$lhitomi,$lsinchou,$ltaiju,$lsprd,$gsprd,$ls0,$ls1,$ls2,$ld0,$ld1,$ld2,$ld3,$ld4,$ld5,$lu0,$lu1,$lu2,$lu3,$lu4,$lu5,$lskdata,$lrndata,$lippan,$ltokugi,$lrengi,$lpitem,$lk_point,$lmoney,$lrentm,$lsoubi,$lgengo,$lkeireki,$ldate,$lhada,$lrevision) = split(/##/, $line);
		&list_chg;
		@list3 = ($lid,$lc_name,$sxl[$lsex],$lage,$llev,$lsyuzoku,$stad[$lstatus],$sk1,$sk2,$lbikou,$lpass,$lc_ename,$lc_pic,$umare[$lumare],$lbirth,$lsyussin,$lkami,$lhitomi,$lsinchou,$ltaiju,$lsprd,$gsprd,$nouryoku,$ls1,$ls2,$ld0,$ld1,$ld2,$ld3,$ld4,$ld5,$lu0,$lu1,$lu2,$lu3,$lu4,$lu5,$lskdata,$lrndata,$lippan,$ltokugi,$lrengi,$lpitem,$k_point,$lmoney,$lrentm,$lsoubi,$lgengo,$lkeireki,$ldate,$lhada,$lrevision);
		#表示項目入れ替え用配列セット
		@tmp = ();
		for ($d = 1;$d < $lcnt; $d++){
			push (@tmp,"$list2[$d],$list3[$d]") if ($list1[$d] eq 1);
		}
		#表示項目入れ替えソート
		@log2 = @tmp;
		@tmp  = ();
		@tmp = sort { $a <=> $b } @log2;
		($tmp,$id) = split(/,/,$tmp[0]);
		#リスト表示
		if ( $in{'mode'} eq "kanri" || $in{'mode'} eq "chg" || $in{'mode'} eq "kreg") {	##管理画面一覧
			print "\t<TR class=h2><TD>$lid</TD><TD><INPUT TYPE='checkbox' NAME='delete' VALUE=\"$lid\"></TD><TD><INPUT TYPE='radio' NAME='id' VALUE=\"$lid\"></TD>";
			foreach (@tmp) {
				local ($tmp,$e) = split(/,/,$_);
				$e = "&nbsp;" if (!$e || $e eq '' || $e eq "\n");	##入力がない場合、ブランクを挿入
				print "<TD>$e</TD>";
			}
			print "<TD><A href=\"$script?mode=seat&id=$lid\" target=seat>→</A></TD><TD><INPUT TYPE='checkbox' NAME='html' VALUE=\"$lid\"></TD></TR>\n";
		} else {	##通常画面一覧
			print "\t<TR class=h2><TD>$lid</TD>";
			foreach (@tmp) {
				local ($tmp,$e) = split(/,/,$_);
				$e = "&nbsp;" if (!$e || $e eq '' || $e eq "\n");	##入力がない場合、ブランクを挿入
				print "<TD>$e</TD>";
			}
			print "<TD><A href=\"$script?mode=seat&id=$lid\" target=seat>→</A></TD></TR>\n";
		}
		@list3 = ();
	}
}

#リスト表示用データ変換
sub list_chg {
		$skc = $lskill1;	#技能１変換
		&skchk;
		$sk1 = $skcn;
		$skc = $lskill2;	#技能２変換
		&skchk;
		$sk2 = $skcn;		
		($k1,$k2) = split(/<>/, $lk_point);
		if ($k2 eq '') { 
			$k_point = $lk_point; 
			$lk_point =~ s/<>//g;
		} else { $k_point = "$k2／$k1";}

		##表示項目を装飾する場合はこの位置にスクリプトを挿入---
		if($list1[22]){	##能力値欄を表示する場合
			local($lr0,$lr1,$lr2,$lr3,$lr4,$lr5,$lhprv,$lmprv,$lsemrv,$lsesrv,$lmorv,$lrurv) = split(/<>/,$lrevision);

			@st = ("$ls0","$ls0","$ls1","$ls1","$ls2","$ls2");	#能力値配列
			@dp = ("$ld0","$ld1","$ld2","$ld3","$ld4","$ld5");	#ダイス目
			@lu = ("$lu0","$lu1","$lu2","$lu3","$lu4","$lu5");	#成長
			@rv = ("$lr0","$lr1","$lr2","$lr3","$lr4","$lr5");	#補正

			#能力値算出
			for ($d = 0;$d < 6; $d++){
				$tmp0 = substr($abi[$d],0,3);
				$tmp1 = $st[$d] + $dp [$d] + $lu[$d] + $rv[$d];
				$tmp2 = int($tmp1 / 6);
				if (!$d) {
					$nouryoku = "$tmp0&nbsp;$tmp1\[$tmp2\]";
				 } else {
					if ( $d ne 3) { $nouryoku = join("&nbsp;",$nouryoku, "$tmp0&nbsp;$tmp1\[$tmp2\]");}
					 else {$nouryoku = join("<BR>",$nouryoku, "$tmp0&nbsp;$tmp1\[$tmp2\]");}
				}
			}
		}

		$ldate	=~ s/\)/)<BR>/g if($list1[49]);	##日付を表示する場合、改行 ##ver0.8 update

		##ここまで----------------------------------------------
}

#リストの件名表示
sub list_ttl {
	&read5;
	$lcnt =@list0;
	@tmp = ();
	$cnt = 0;
	for ($d = 0;$d < $lcnt; $d++){
		push (@tmp,"$list2[$d],$list0[$d]") if ($list1[$d] eq 1);
	}

	@log1 = @tmp;
	$lcnt = $#log1;
	$width = "650";
	if ($lcnt > 7) {
		$tcnt = 0;
		$tcnt = $lcnt - 7;
		$width = $width + ($tcnt * 100);
	}

        print "\n<div style=\"margin-left:auto;margin-right:auto;width:$width";
	print "px;\">\n<TABLE cellpadding=2 cellspacing=1>\n";
        print "\t<TR class=h1>";
	@tmp  = ();
	@tmp = sort { $a <=> $b } @log1;
	foreach (@tmp) {
		local ($tmp,$d) = split(/,/,$_);
		print "<TD><B>$d</B></TD>";
	}
	print "<TD><B>詳細</B></TD></TR>\n";	##詳細列は一番後ろに表示
}		##ver0.6 update END

#名誉アイテム変換
sub pride {
	
	$gpridep = $in{'spridep'};
	$pitem = "";
	$cnt = $in{'picnt'};
	for ($i=0;$i<$cnt;$i++) {
		$gpridep = $gpridep + $in{"ppoint$i"};
		if (!$pitem) { $pitem =join("<>", $in{"pitem$i"}, $in{"ppoint$i"}); }
		 else {
			if ($in{"pitem$i"}) {
				$pitem[$i] = "$in{\"pitem$i\"}<>$in{\"ppoint$i\"}";
				$pitem =join("<#>", $pitem, $pitem[$i]); 
			}
		}
	}
}

#武器・防具変換
sub f2chg {
	$wep = "";
	$dif = "";
	$sou = "";
	$wc = $in{'wc'};
	$u_slev= "&nbsp;";

	for ($i=0;$i<=$wc;$i++) {
		if ($in{"wep$i"} ne ""){
			$u_slev = 0;
			$glev = 0;
			$sno = $in{"u_s$i"};
			&rskill if ($in{"u_s$i"});	#技能レベル取得
			if($in{"gun$i"}){	#ガン利用
				$tmp = $u_slev;	#シューター技能レベルを待避
				$u_slev = 0;	#変数初期化
				$sno = 9;
				&rskill;
				$glev = $u_slev;#マギテック技能レベル取得
				$u_slev = $tmp;	#待避レベルを元の変数に移動
			}
			$wepon[$i] = "$in{\"u_s$i\"}<>$u_slev<>$in{\"hd$i\"}<>$in{\"wkin$i\"}<>$in{\"wirk$i\"}<>$in{\"u_ssyu$i\"}<>$in{\"u_sc$i\"}<>$in{\"u_bk$i\"}<>$glev<>$in{\"gun$i\"}<#>";
			if (!$wep) { $wep =join("<>", $in{"wep$i"}, $wepon[$i]); }
			 else { if ($in{"wep$i"}) {$wep =join("<>", $wep, $in{"wep$i"}, $wepon[$i]); } }
		}
	}
	for ($i=0;$i<4;$i++) {
		$u_slev = 0;
		$sno = $in{"b_sk$i"};
		&rskill if ($in{"b_sk$i"});
		$difen[$i] = "$in{\"b_sk$i\"}<>$u_slev<>$in{\"b_kin$i\"}<>$in{\"b_syu$i\"}<>$in{\"b_bou$i\"}<#>";
		if (!$dif) { $dif =join("<>", $in{"bou$i"}, $difen[$i]); }
		 else { $dif =join("<>", $dif, $in{"bou$i"}, $difen[$i]); }
	}
#装飾品の表示
	if ($flg_sosk && $in{'sousyoku'}) {	#フラグが有効かつ入力がある場合
		$in{'sousyoku'} =~ s/\t//g;   #装飾変換
		$in{'sousyoku'} =~ s/\n/<BR>/g;   #装飾変換
		$cnt = 0;
		foreach  (split(/<BR>/,$in{'sousyoku'})) {
			if ($_){
				if (!$cnt) {
					$sosk = "$_";
					$cnt++;
				} else { $sosk = join("<#>", "$sosk", "$_"); }
			}
		}
	}
	$wep =~ s/<#><>/<#>/g;
	$dif =~ s/<#><>/<#>/g;
	$sosk =~ s/<#><>/<#>/g;
	$sosk =~ s/\n//g;
	$sosk =~ s/\r\n//g;
	$sosk =~ s/\r|\n//g;

}

#フリーコメント編集
sub fcchg {	##ver0.7 update
	$cnt = 0; $tmp1 =''; $tmp2 =''; $tmp3 ='';	#初期化
	$tmp1 = "$in{'fc'}";				#変数にフリーコメント内容をセット
	$cnt = length($tmp1);				#改行を含む全体の文字数をカウントする。

	if (($max_fc ne 0) && ( $cnt > $max_fc )) {
	#最大サイズが設定されていて、かつ全体の文字数が最大サイズを超えている場合
		$cnt = 0;	$tmp = 0;		#変数クリア
		foreach (split(/<BR>/,$tmp1)) {		#改行毎に処理を行う。
			$tmp = length($_);		#１行分の文字数をカウントする。
			if (($cnt + $tmp) > $max_fc) {	#最大文字数を超えた場合
				$tmp3 = $_;		#変数を待避
				last;			#ループを抜けて終了
			}
			if ($cnt ne 0){			#累積文字数が0でない場合改行を追加し文字を連結
				$tmp2 = join ("<BR>", $tmp2, $_);
			 } else {			#累積文字数が0の場合、そのまま受け渡し
				$tmp2 = "$_";
			}
			$cnt = $cnt + $tmp;		#累積文字数計算
			$tmp = 0;			#変数クリア
		}
		$tmp = $max_fc - $cnt;			#最終行の残り文字数計算
		if ($tmp > 0 && $tmp3 ne ''){		#残り文字数に余裕があり、かつ最終行に文字がある場合
			$tmp1 =substr("$tmp3", 0, $tmp);#最終行の文字カット
			if ($cnt ne 0){			#累積文字数が0でない場合改行を追加し文字を連結
				$tmp2 = join ("<BR>", $tmp2, $tmp1);
			 } else {			#累積文字数が0の場合、そのまま受け渡し
				$tmp2 = "$tmp1";
			}
		}
		$tmp1 = $tmp2;				#変数に処理後文字列をセット
	}
}	##ver0.7 update END

sub tmpchg { ##ver0.7 update
	#文字置換
		$tmp =~ s/ /&nbsp;/g;
		$tmp =~ tr/+/ /ds;
		$tmp =~ s/,/，/g;
		$tmp =~ s/</&lt;/g;
		$tmp =~ s/>/&gt;/g;
		$tmp =~ s/&lt;&gt;/<>/g;
		$tmp =~ s/&lt;#&gt;/<#>/g;

	#数字半角変換
		$tmp =~ s/０/0/g; $tmp =~ s/１/1/g; $tmp =~ s/２/2/g; $tmp =~ s/３/3/g; $tmp =~ s/４/4/g; $tmp =~ s/５/5/g; $tmp =~ s/６/6/g; $tmp =~ s/７/7/g; $tmp =~ s/８/8/g; $tmp =~ s/９/9/g;

	#改行処理
		$tmp =~ s/\n/<BR>/g;
		$tmp =~ s/\r\n/<BR>/g;
		$tmp =~ s/\r|\n//g;
}

sub getimg { ##ver0.7 update
# 画像処理
	$macbin=0;

	foreach (@img) {
		if ($_ =~ /(.*)Content-type:(.*)/i) { $type=$2; }
		if ($_ =~ /(.*)filename=(.*)/i) { $file=$2; }
		if ($_ =~ /application\/x-macbinary/i) { $macbin=1; }
	}	

	$type =~ s/\r//g;
	$type =~ s/\n//g;
	$file =~ tr/\"\x0D\x0A//d;

	# ファイル形式を認識
	if ($type =~ /image\/gif/i) { $type=".gif";}
	 elsif ($type =~ /image\/jpeg/i) { $type=".jpg";}
	 elsif ($type =~ /image\/pjpeg/i) { $type=".jpg";}
	 elsif ($type =~ /image\/x-png/i) { $type=".png";}
	 else {
		unlink "$img1" if (-e $img1);
		&error("$error[9]"); 
	}

	# マックバイナリ対策
	if ($macbin) {
		$length = substr($upfile,83,4);
		$length = unpack("%N",$length);
		$upfile = substr($upfile,128,$length);
	}

	## 添付データを書き込み（バイナリモード）
	# 出力先フォルダがない場合自動作成
	unless (-d $imglib) { mkdir($imglib, 0755);}
	$imglib = './' if ($imglib eq '');

	# ファイルの種類を確認、該当データが存在する場合削除
	foreach (@ftype){
		$tmp = "$imglib$no$_";
		if(-f $tmp) { unlink $tmp; last; }
	}

	# 画像データのアップロード
	$img = "$imglib$no$type";
	&error("$error[10]") if ((!open(OUT,"> $img")) && $clip_err);
	binmode(OUT);
	binmode(STDOUT);
	print OUT $upfile;
	close(OUT);
	chmod (0666,$img);

	# 画像の絶対URLを取得
	$img = "$path$imglib$no$type";
}	##ver0.7 update END

#　HTMLのヘッダー
sub head {
	print "Content-type: text/html\n";
	print "$head";
	print "<TITLE>$title</TITLE>\n";
	print "<link rel=stylesheet type=\"text/css\" href=\"$style\">\n";
	print "$hd1";
        print "</HEAD>\n<BODY>";
}

sub foot {
	# 著作権表示（削除しないで下さい）
	&fot;
	print "$foot";
	print "<div class=r><img src=\"$URL\img/c211.gif\" width=44 height=18 alt='更新情報' title='更新情報'></div>" if($flg_new);
	print "</BODY>\n</HTML>\n";
}

#------- エラー処理  -----------#
sub error {
	if (-f $tmpfile) { unlink $tmpfile; }
	$title = 'ERROR';
	$title = '削除完了' if($flg_user);
	$style = $lstyle;
        &head;
	print "$link<BR><BR><BR><BR><BR><div class=c><span class=t>$_[0]</span></div>";	##ver0.4 update
	&footer;
	exit;
}

#----- パスワード暗号処理 -----#
sub encrypt {
	local($inpw) = $_[0];
	local(@SALT, $salt, $encrypt);

	@SALT = ('a'..'z', 'A'..'Z', '0'..'9', '.', '/');
	srand;
	$salt = $SALT[int(rand(@SALT))] . $SALT[int(rand(@SALT))];
	$encrypt = crypt($inpw, $salt) || crypt ($inpw, '$1$' . $salt);
	return $encrypt;
}


#---- パスワード照合処理 ----#
sub decrypt {
	local($inpw, $logpw) = @_;
	local($salt, $key, $check);

	$salt = $logpw =~ /^\$1\$(.*)\$/ && $1 || substr($logpw, 0, 2);
	$check = "no";
	if (crypt($inpw, $salt) eq "$logpw" || crypt($inpw, '$1$' . $salt) eq "$logpw")
		{ $check = "yes"; }
	return $check;
}
#-------- ホスト名取得 --------#
sub get_host {
	$host = $ENV{'REMOTE_HOST'};
	$addr = $ENV{'REMOTE_ADDR'};

	if ($get_remotehost) {
		if ($host eq "" || $host eq "$addr") {
			$host = gethostbyaddr(pack("C4", split(/\./, $addr)), 2);
		}
	}
	if ($host eq "") { $host = $addr; }
}
#---------------------------------------------------------------------------------------------------


;
_END_